/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class CarouselAP
extends AP6 {
    static final String[][] text = new String[][]{{"de", "Modell eines Kettenkarussells", "Karussell", "Karussell mit Kr\u00e4ften", "Skizze", "Zahlenwerte", "Pause", "Weiter", "Zeitlupe", "Umlaufzeit:", "Abstand der Aufh\u00e4ngungen", "von der Drehachse:", "Fadenl\u00e4nge:", "Masse:", "Frequenz:", "Winkelgeschwindigkeit:", "Radius:", "Geschwindigkeit:", "Winkel:", "Gewicht:", "Zentripetalkraft:", "Belastung des Fadens:", ""}, {"en", "Model of a Carousel", "Carousel", "Carousel with forces", "Sketch", "Numerical values", "Pause", "Resume", "Slow motion", "Period:", "Distance between suspensions", "and axis of rotation:", "Length of the strings:", "Mass:", "Frequency:", "Angular velocity:", "Radius:", "Velocity:", "Angle:", "Weight:", "Centripetal force:", "Tension in the string:", ""}};
    private int[] gaps = new int[]{5, 2, 2, 2, 5, 5, 5, 2, 0, 2, 2, 5, 0, 5};
    final int width = 700;
    final int height = 400;
    final int width0 = 400;
    final int xM = 220;
    final int yM = 130;
    final double c0 = Math.sqrt(0.5);
    final double pix = 100.0;
    FontMetrics fmH;
    CanvasAP cv;
    Panel6 pan;
    JRadioButton rb1;
    JRadioButton rb2;
    JRadioButton rb3;
    JRadioButton rb4;
    StartButton bPause;
    JCheckBox cbSlow;
    JTextField tfT;
    JTextField tfR0;
    JTextField tfLF;
    JTextField tfM;
    Color[] col;
    Color[] col0;
    Color bgCanvas;
    Color bgPanel;
    Color colorButton;
    Color colorWeight;
    Color colorTension;
    Color colorRadialForce;
    Color colorBall;
    Color colorAngle;
    String coauthor;
    String text01;
    String text02;
    String text03;
    String text04;
    String text05;
    String text06;
    String text07;
    String text08;
    String text09;
    String text10;
    String text11;
    String text12;
    String text13;
    String text14;
    String text15;
    String text16;
    String text17;
    String text18;
    String text19;
    String text20;
    double[] poly1X;
    double[] poly1Y;
    double[] poly2X;
    double[] poly2Y;
    double[] poly3X;
    double[] poly3Y;
    double t;
    boolean on;
    boolean slow;
    int nr;
    double theta;
    double cosTh;
    double sinTh;
    double r0;
    double rr0;
    double lF;
    double m;
    double fG;
    double fR;
    double r;
    double phi;
    double cosPhi;
    double sinPhi;
    double alpha;
    double tPer;
    double omega;
    double fFactor;
    double zz;
    double dy0;
    double rK;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(700, 400);
    }

    @Override
    protected void initAttributes() {
        this.on = true;
        this.slow = false;
        this.nr = 1;
        this.theta = 0.3490658503988659;
        this.cosTh = Math.cos(this.theta);
        this.sinTh = Math.sin(this.theta);
        this.r0 = 0.8;
        this.lF = 1.0;
        this.tPer = 4.0;
        this.m = 1.0;
        this.calculation();
        this.poly1X = new double[3];
        this.poly1Y = new double[3];
        this.poly2X = new double[4];
        this.poly2Y = new double[4];
        this.poly3X = new double[4];
        this.poly3Y = new double[4];
        this.setPoint(this.poly1X, this.poly1Y, 0, 220.0, 130.0 - 15.0 * this.cosTh);
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.colorButton = this.getColor(Color.yellow, "colorButton");
        this.colorWeight = this.getColor(Color.black, "colorWeight");
        this.colorTension = this.getColor(Color.blue, "colorTension");
        this.colorRadialForce = this.getColor(Color.red, "colorRadialForce");
        this.colorBall = this.getColor(Color.white, "colorBall");
        this.colorAngle = this.getColor(Color.cyan, "colorAngle");
        this.col0 = new Color[4];
        this.col0[0] = this.getColor(Color.cyan, "color01");
        this.col0[1] = this.getColor(Color.pink, "color02");
        this.col0[2] = this.getColor(Color.green, "color03");
        this.col0[3] = this.getColor(Color.orange, "color04");
        this.col = new Color[8];
        this.col[0] = this.getColor(Color.red, "color11");
        this.col[1] = this.getColor(Color.cyan, "color12");
        this.col[2] = this.getColor(Color.pink, "color13");
        this.col[3] = this.getColor(Color.blue, "color14");
        this.col[4] = this.getColor(Color.orange, "color15");
        this.col[5] = this.getColor(Color.magenta, "color16");
        this.col[6] = this.getColor(Color.green, "color17");
        this.col[7] = this.getColor(Color.black, "color18");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.text04 = this.getText(t[5], "text04");
        this.text05 = this.getText(t[6], "text05");
        this.text06 = this.getText(t[7], "text06");
        this.text07 = this.getText(t[8], "text07");
        this.text08 = this.getText(t[9], "text08");
        this.text09 = this.getText(t[10], "text09");
        this.text10 = this.getText(t[11], "text10");
        this.text11 = this.getText(t[12], "text11");
        this.text12 = this.getText(t[13], "text12");
        this.text13 = this.getText(t[14], "text13");
        this.text14 = this.getText(t[15], "text14");
        this.text15 = this.getText(t[16], "text15");
        this.text16 = this.getText(t[17], "text16");
        this.text17 = this.getText(t[18], "text17");
        this.text18 = this.getText(t[19], "text18");
        this.text19 = this.getText(t[20], "text19");
        this.text20 = this.getText(t[21], "text20");
        this.coauthor = this.getText(t[22], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 400, 400);
        this.add(this.cv);
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 3, this.gaps);
        this.pan.setBounds(400, 0, 300, 400);
        ButtonGroup bg = new ButtonGroup();
        this.rb1 = this.pan.newRadioButton(this.text01, true, bg);
        this.rb2 = this.pan.newRadioButton(this.text02, false, bg);
        this.rb3 = this.pan.newRadioButton(this.text03, false, bg);
        this.rb4 = this.pan.newRadioButton(this.text04, false, bg);
        this.bPause = new StartButton("", this.text05, this.text06);
        this.bPause.setState(1);
        this.pan.add(this.bPause, this.colorButton, Color.black);
        this.cbSlow = new JCheckBox(this.text07);
        this.pan.add(this.cbSlow, this.bgPanel, Color.black);
        this.tfT = this.pan.newInputField(this.text08, this.second, this.bgPanel, Color.black, 2);
        this.tfT.setText(this.toString(this.tPer, 2));
        this.pan.add(this.text09);
        this.tfR0 = this.pan.newInputField(this.text10, this.meter, this.bgPanel, Color.black, 2);
        this.tfR0.setText(this.toString(this.r0, 2));
        this.tfLF = this.pan.newInputField(this.text11, this.meter, this.bgPanel, Color.black, 2);
        this.tfLF.setText(this.toString(this.lF, 2));
        this.tfM = this.pan.newInputField(this.text12, this.kilogram, this.bgPanel, Color.black, 2);
        this.tfM.setText(this.toString(this.m, 2));
        this.pan.add(1999);
        this.pan.add(this.coauthor);
        this.add(this.pan);
        this.bPause.addActionListener(this);
        this.cbSlow.addActionListener(this);
    }

    @Override
    public void run() {
        long t0 = System.currentTimeMillis();
        while (this.thr == Thread.currentThread()) {
            this.cv.repaint();
            try {
                Thread.sleep(this.on ? 50L : 100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            long t1 = System.currentTimeMillis();
            if (this.on) {
                double dt = (double)(t1 - t0) / 1000.0;
                this.t += this.slow ? dt / 10.0 : dt;
            }
            t0 = t1;
        }
    }

    void setPoint(double[] px, double[] py, int i, double x, double y) {
        px[i] = x;
        py[i] = y;
    }

    void calculation() {
        this.omega = Math.PI * 2 / this.tPer;
        if (this.r0 == 0.0) {
            double a = 9.81 / (this.lF * this.omega * this.omega);
            this.alpha = a > 1.0 ? 0.0 : Math.acos(a);
        } else {
            double u = 0.0;
            double o = 1.5707963267948966;
            double mi = (u + o) / 2.0;
            while (o - u > 1.0E-10) {
                double a = 9.81 * Math.tan(mi) - this.omega * this.omega * (this.r0 + this.lF * Math.sin(mi));
                if (a > 0.0) {
                    o = mi;
                } else {
                    u = mi;
                }
                mi = (u + o) / 2.0;
            }
            this.alpha = mi;
        }
        this.r = this.r0 + this.lF * Math.sin(this.alpha);
        this.fG = this.m * 9.81;
        this.fR = this.m * this.r * this.omega * this.omega;
        this.fFactor = 5.0 / this.m;
        this.rr0 = this.r0 * 100.0;
        this.dy0 = this.fFactor * this.fG * this.cosTh;
        this.rK = 10.0;
        if (this.r0 < 0.5) {
            this.rK = Math.max(2.0, this.r0 * 20.0);
        }
        this.zz = -this.lF * 100.0 * Math.cos(this.alpha);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o == this.rb1) {
            this.nr = 1;
        } else if (o == this.rb2) {
            this.nr = 2;
        } else if (o == this.rb3) {
            this.nr = 3;
        } else if (o == this.rb4) {
            this.nr = 4;
        } else if (o == this.bPause) {
            this.bPause.setState();
            this.on = !this.on;
        } else if (o instanceof JTextField) {
            this.tPer = this.inputTF(this.tfT, 2.0, 10.0, 2);
            this.r0 = this.inputTF(this.tfR0, 0.0, 1.0, 2);
            this.lF = this.inputTF(this.tfLF, 0.5, 1.0, 2);
            this.m = this.inputTF(this.tfM, 0.1, 10.0, 2);
        }
        this.slow = this.cbSlow.isSelected();
        this.calculation();
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, CarouselAP.this.bgCanvas);
            CarouselAP.this.fmH = this.getFontMetrics(this.fH);
        }

        void oben(Graphics2D g) {
            double xA = (CarouselAP.this.rr0 + 20.0) * CarouselAP.this.cosPhi;
            double yA = (CarouselAP.this.rr0 + 20.0) * CarouselAP.this.sinPhi;
            double zCos = 15.0 * CarouselAP.this.cosTh;
            for (int i = 0; i < 4; ++i) {
                boolean visible = Math.cos(CarouselAP.this.phi + ((double)i + 0.5) * Math.PI / 4.0) >= 0.0;
                double xB = (xA - yA) * CarouselAP.this.c0;
                double yB = (xA + yA) * CarouselAP.this.c0;
                double hA = xA * CarouselAP.this.sinTh;
                double hB = xB * CarouselAP.this.sinTh;
                double uA = 220.0 + yA;
                double vA = 130.0 + hA - zCos;
                double uB = 220.0 + yB;
                double vB = 130.0 + hB - zCos;
                double uC = 220.0 - yA;
                double vC = 130.0 - hA - zCos;
                double uD = 220.0 - yB;
                double vD = 130.0 - hB - zCos;
                if (visible) {
                    CarouselAP.this.setPoint(CarouselAP.this.poly2X, CarouselAP.this.poly2Y, 0, uA, vA);
                    CarouselAP.this.setPoint(CarouselAP.this.poly2X, CarouselAP.this.poly2Y, 1, uA, vA + zCos);
                    CarouselAP.this.setPoint(CarouselAP.this.poly2X, CarouselAP.this.poly2Y, 2, uB, vB + zCos);
                    CarouselAP.this.setPoint(CarouselAP.this.poly2X, CarouselAP.this.poly2Y, 3, uB, vB);
                } else {
                    CarouselAP.this.setPoint(CarouselAP.this.poly2X, CarouselAP.this.poly2Y, 0, uC, vC);
                    CarouselAP.this.setPoint(CarouselAP.this.poly2X, CarouselAP.this.poly2Y, 1, uC, vC + zCos);
                    CarouselAP.this.setPoint(CarouselAP.this.poly2X, CarouselAP.this.poly2Y, 2, uD, vD + zCos);
                    CarouselAP.this.setPoint(CarouselAP.this.poly2X, CarouselAP.this.poly2Y, 3, uD, vD);
                }
                CarouselAP.this.setPoint(CarouselAP.this.poly1X, CarouselAP.this.poly1Y, 1, uA, vA);
                CarouselAP.this.setPoint(CarouselAP.this.poly1X, CarouselAP.this.poly1Y, 2, uB, vB);
                CanvasAP.polygon(g, CarouselAP.this.poly1X, CarouselAP.this.poly1Y, CarouselAP.this.col[i], true);
                if (!visible) {
                    CanvasAP.polygon(g, CarouselAP.this.poly2X, CarouselAP.this.poly2Y, CarouselAP.this.col[i], true);
                }
                CarouselAP.this.setPoint(CarouselAP.this.poly1X, CarouselAP.this.poly1Y, 1, uC, vC);
                CarouselAP.this.setPoint(CarouselAP.this.poly1X, CarouselAP.this.poly1Y, 2, uD, vD);
                Color c = CarouselAP.this.col[(i + 4) % 8];
                CanvasAP.polygon(g, CarouselAP.this.poly1X, CarouselAP.this.poly1Y, c, true);
                if (visible) {
                    CanvasAP.polygon(g, CarouselAP.this.poly2X, CarouselAP.this.poly2Y, c, true);
                }
                xA = xB;
                yA = yB;
            }
        }

        void unten(Graphics2D g) {
            double x = CarouselAP.this.rr0 * CarouselAP.this.cosPhi / 2.0;
            double y = CarouselAP.this.rr0 * CarouselAP.this.sinPhi / 2.0;
            double z = 0.0;
            double z0 = 180.0 * CarouselAP.this.cosTh;
            for (int i = 0; i < 4; ++i) {
                boolean visible;
                boolean bl = visible = Math.cos(CarouselAP.this.phi + ((double)i + 0.5) * Math.PI / 4.0) >= 0.0;
                if (!visible) {
                    x = -x;
                    y = -y;
                }
                double x0 = 220.0 + y;
                double y0 = 130.0 + x * CarouselAP.this.sinTh - z * CarouselAP.this.cosTh;
                CarouselAP.this.setPoint(CarouselAP.this.poly3X, CarouselAP.this.poly3Y, 0, x0, y0);
                CarouselAP.this.setPoint(CarouselAP.this.poly3X, CarouselAP.this.poly3Y, 1, x0, y0 + z0);
                double xx = (x - y) * CarouselAP.this.c0;
                y = (x + y) * CarouselAP.this.c0;
                x = xx;
                x0 = 220.0 + y;
                y0 = 130.0 + x * CarouselAP.this.sinTh - z * CarouselAP.this.cosTh;
                CarouselAP.this.setPoint(CarouselAP.this.poly3X, CarouselAP.this.poly3Y, 2, x0, y0 + z0);
                CarouselAP.this.setPoint(CarouselAP.this.poly3X, CarouselAP.this.poly3Y, 3, x0, y0);
                CanvasAP.polygon(g, CarouselAP.this.poly3X, CarouselAP.this.poly3Y, CarouselAP.this.col0[i % 4], true);
                if (visible) continue;
                x = -x;
                y = -y;
            }
        }

        void pendulum(Graphics2D g, boolean vorne) {
            double x = CarouselAP.this.rr0 * CarouselAP.this.cosPhi;
            double y = CarouselAP.this.rr0 * CarouselAP.this.sinPhi;
            for (int i = 0; i < 8; ++i) {
                boolean visible = vorne ^ x <= 0.0;
                if (visible) {
                    double w = CarouselAP.this.phi + (double)i * Math.PI / 4.0;
                    double cos = Math.cos(w);
                    double sin = Math.sin(w);
                    double x0 = 220.0 + y;
                    double y0 = 130.0 + x * CarouselAP.this.sinTh;
                    double xx = 100.0 * CarouselAP.this.r * cos;
                    double yy = 100.0 * CarouselAP.this.r * sin;
                    double x1 = 220.0 + yy;
                    double y1 = 130.0 + xx * CarouselAP.this.sinTh - CarouselAP.this.zz * CarouselAP.this.cosTh;
                    g.setColor(Color.black);
                    CanvasAP.line(g, x0, y0, x1, y1);
                    CanvasAP.circle(g, x1, y1, CarouselAP.this.rK, CarouselAP.this.colorBall, true);
                    if (CarouselAP.this.nr == 2) {
                        g.setColor(CarouselAP.this.colorWeight);
                        CanvasAP.arrow(g, 3.0, x1, y1, x1, y1 + CarouselAP.this.dy0);
                        double dx = CarouselAP.this.fFactor * CarouselAP.this.fR * sin;
                        double dy = CarouselAP.this.fFactor * CarouselAP.this.fR * cos * CarouselAP.this.sinTh;
                        CanvasAP.line(g, x1, y1 + CarouselAP.this.dy0, x1 - dx, y1 - dy);
                        CanvasAP.line(g, x1 - dx, y1 - dy, x1 - dx, y1 - dy - CarouselAP.this.dy0);
                        g.setColor(CarouselAP.this.colorRadialForce);
                        CanvasAP.arrow(g, 3.0, x1, y1, x1 - dx, y1 - dy);
                        g.setColor(CarouselAP.this.colorTension);
                        CanvasAP.arrow(g, 3.0, x1, y1, x1 - dx, y1 - dy - CarouselAP.this.dy0);
                    }
                }
                double xx = (x - y) * CarouselAP.this.c0;
                y = (x + y) * CarouselAP.this.c0;
                x = xx;
            }
            if (CarouselAP.this.nr == 2) {
                this.scaleArrow(g);
            }
        }

        void scaleArrow(Graphics2D g) {
            g.setColor(Color.black);
            int yN = 370;
            int n = 1;
            n = CarouselAP.this.fFactor > 20.0 ? 1 : (CarouselAP.this.fFactor > 2.0 ? 10 : (CarouselAP.this.fFactor > 0.2 ? 100 : 1000));
            double dN = (double)n * CarouselAP.this.fFactor;
            String s = "" + n + " " + CarouselAP.this.newton;
            CanvasAP.arrow(g, 3.0, 20.0, (double)yN - dN, 20.0, yN);
            CanvasAP.setAntiAliasing(g, false);
            g.drawString(s, 25, (int)Math.round((double)yN - dN / 2.0));
            CanvasAP.setAntiAliasing(g, true);
        }

        void angabe(Graphics2D g, String text, double a, int n, String u, int y) {
            g.drawString(text, 80, y);
            g.drawString(CarouselAP.this.toString2(a, n, 1.0E-6) + " " + u, 280, y);
        }

        void zahlen(Graphics2D g) {
            CanvasAP.setAntiAliasing(g, false);
            g.setColor(Color.black);
            this.angabe(g, CarouselAP.this.text13, 1.0 / CarouselAP.this.tPer, 3, CarouselAP.this.hertz, 80);
            this.angabe(g, CarouselAP.this.text14, CarouselAP.this.omega, 3, "rad/s", 100);
            this.angabe(g, CarouselAP.this.text15, CarouselAP.this.r, 3, CarouselAP.this.meter, 140);
            this.angabe(g, CarouselAP.this.text16, CarouselAP.this.r * CarouselAP.this.omega, 3, CarouselAP.this.meterPerSecond, 180);
            this.angabe(g, CarouselAP.this.text17, CarouselAP.this.alpha / (Math.PI / 180), 3, CarouselAP.this.degree, 220);
            this.angabe(g, CarouselAP.this.text18, CarouselAP.this.fG, 3, CarouselAP.this.newton, 260);
            this.angabe(g, CarouselAP.this.text19, CarouselAP.this.fR, 3, CarouselAP.this.newton, 280);
            double f = Math.sqrt(CarouselAP.this.fG * CarouselAP.this.fG + CarouselAP.this.fR * CarouselAP.this.fR);
            this.angabe(g, CarouselAP.this.text20, f, 3, CarouselAP.this.newton, 300);
            CanvasAP.setAntiAliasing(g, true);
        }

        void skizze(Graphics2D g) {
            double x0 = 140.0 + CarouselAP.this.rr0;
            if (CarouselAP.this.alpha > Math.PI / 90) {
                CanvasAP.angle(g, x0, 130.0, 15.0, 4.71238898038469, CarouselAP.this.alpha, CarouselAP.this.colorAngle);
            }
            g.setColor(Color.black);
            CanvasAP.line(g, 140.0, 40.0, 140.0, 340.0);
            CanvasAP.line(g, 140.0, 130.0, x0, 130.0);
            double x1 = 140.0 + CarouselAP.this.r * 100.0;
            double y1 = 130.0 - CarouselAP.this.zz;
            CanvasAP.line(g, x0, 130.0, x0, y1);
            CanvasAP.line(g, x0, 130.0, x1, y1);
            CanvasAP.line(g, 140.0, y1, x1, y1);
            CanvasAP.circle(g, x1, y1, CarouselAP.this.rK, CarouselAP.this.colorBall, true);
            double dy0 = CarouselAP.this.fFactor * CarouselAP.this.fG;
            CanvasAP.arrow(g, 3.0, x1, y1, x1, y1 + dy0);
            double dx = CarouselAP.this.fFactor * CarouselAP.this.fR;
            CanvasAP.line(g, x1, y1 + dy0, x1 - dx, y1);
            CanvasAP.line(g, x1 - dx, y1, x1 - dx, y1 - dy0);
            g.setColor(CarouselAP.this.colorRadialForce);
            CanvasAP.arrow(g, 3.0, x1, y1, x1 - dx, y1);
            g.setColor(CarouselAP.this.colorTension);
            CanvasAP.arrow(g, 3.0, x1, y1, x1 - dx, y1 - dy0);
            this.scaleArrow(g);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP.setAntiAliasing(g2, true);
            CarouselAP.this.phi = Math.PI * (CarouselAP.this.t / CarouselAP.this.tPer);
            CarouselAP.this.cosPhi = Math.cos(CarouselAP.this.phi);
            CarouselAP.this.sinPhi = Math.sin(CarouselAP.this.phi);
            g.setFont(this.fH);
            if (CarouselAP.this.nr <= 2) {
                this.pendulum(g2, false);
                this.unten(g2);
                this.pendulum(g2, true);
                this.oben(g2);
            } else if (CarouselAP.this.nr == 3) {
                this.skizze(g2);
            } else if (CarouselAP.this.nr == 4) {
                this.zahlen(g2);
            }
        }
    }
}

